/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structures.helpers.Structure;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.InstantStructurePlacer;
import com.ldtteam.structurize.util.PlacementSettings;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.jetbrains.annotations.NotNull;

public class StructurePlacementUtils {
    public static boolean isStructureBlockEqualWorldBlock(World world, BlockPos blockPosition, IBlockState state) {
        Block structureBlock = state.func_177230_c();
        if (structureBlock == ModBlocks.blockSubstitution) {
            return true;
        }
        IBlockState worldBlockState = world.func_180495_p(blockPosition);
        if (structureBlock == ModBlocks.blockSolidSubstitution && worldBlockState.func_185904_a().func_76220_a()) {
            return true;
        }
        Block worldBlock = worldBlockState.func_177230_c();
        if (structureBlock instanceof BlockDoor || structureBlock == Blocks.field_150457_bL) {
            return structureBlock == worldBlock;
        }
        if (structureBlock instanceof BlockStairs && state == worldBlockState || BlockUtils.isGrassOrDirt(structureBlock, worldBlock, state, worldBlockState)) {
            return true;
        }
        return blockPosition.func_177956_o() <= 0 || state == worldBlockState;
    }

    public static void unloadStructure(@NotNull World world, @NotNull BlockPos pos, @NotNull String first, Rotation rotation, @NotNull Mirror mirror) {
        Structure structure = new Structure(world, first, new PlacementSettings(mirror, rotation));
        InstantStructurePlacer structureWrapper = new InstantStructurePlacer(structure);
        structure.setPosition(pos);
        structure.rotate(rotation, world, pos, mirror);
        structureWrapper.removeStructure(pos.func_177973_b((Vec3i)structure.getOffset()));
    }

    public static void loadAndPlaceShapeWithRotation(WorldServer worldObj, Blueprint blueprint, @NotNull BlockPos pos, Rotation rotation, @NotNull Mirror mirror, EntityPlayerMP player) {
        try {
            Structure structure = new Structure((World)worldObj);
            structure.setBluePrint(blueprint);
            structure.setPlacementSettings(new PlacementSettings(Mirror.NONE, Rotation.NONE));
            structure.setPosition(pos);
            structure.rotate(rotation, (World)worldObj, pos, mirror);
            InstantStructurePlacer structureWrapper = new InstantStructurePlacer(structure);
            structureWrapper.setupStructurePlacement(pos.func_177973_b((Vec3i)structure.getOffset()), false, player);
        }
        catch (IllegalStateException e) {
            Log.getLogger().warn("Could not load structure!", (Throwable)e);
        }
    }

    public static void loadAndPlaceStructureWithRotation(World worldObj, @NotNull String name, @NotNull BlockPos pos, Rotation rotation, @NotNull Mirror mirror, boolean complete, EntityPlayerMP player) {
        try {
            Structure structure = new Structure(worldObj, name, new PlacementSettings(mirror, rotation));
            structure.setPosition(pos);
            structure.rotate(rotation, worldObj, pos, mirror);
            InstantStructurePlacer structureWrapper = new InstantStructurePlacer(structure);
            structureWrapper.setupStructurePlacement(pos.func_177973_b((Vec3i)structure.getOffset()), complete, player);
        }
        catch (IllegalStateException e) {
            Log.getLogger().warn("Could not load structure!", (Throwable)e);
        }
    }
}

